<?php

namespace XF\Entity;

use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Structure;

/**
 * COLUMNS
 * @property int $user_id
 * @property string $field_id
 * @property string $field_value
 */
class UserFieldValue extends Entity
{
	public static function getStructure(Structure $structure)
	{
		$structure->table = 'xf_user_field_value';
		$structure->shortName = 'XF:UserFieldValue';
		$structure->primaryKey = ['user_id', 'field_id'];
		$structure->columns = [
			'user_id' => ['type' => self::UINT, 'required' => true],
			'field_id' => ['type' => self::STR, 'maxLength' => 25,
				'match' => self::MATCH_ALPHANUMERIC,
			],
			'field_value' => ['type' => self::STR, 'default' => ''],
		];
		$structure->getters = [];
		$structure->relations = [];

		return $structure;
	}
}
